#ifndef LLF_ECPKI_DH_H
#define LLF_ECPKI_DH_H

/*
* All the includes that are needed for code using this module to
* Compile correctly should be #included here.
*/

#include "CE2_public.h"

#ifdef __cplusplus
extern "C"
{
#endif

/*
* Creation date : Tues Mar 03 09:00:00 2007
* Last modified : %modify_time%
*/
/** @file
* \brief This file contains declaration of low level function
* for creation of shared secret, which worked with 
* LibTomCrypt. 
*
* \version LLF_ECPKI_DH.h#1:csrc:1
* \author Yermalayeu Ihar
* \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
* All Rights reserved
*/

/************************ Defines *****************************/
/************************ Enums *******************************/
/************************ Typedefs ****************************/
/************************ Structs *****************************/
/************************ Public Variables ********************/
/************************ Public Functions ********************/

/**
****************************************************************
* Function Name: 
*  LLF_ECDH_SVDP_DH
*
* Inputs:
* @param BuildedPartnerPublKey_ptr [in] - A pointer to a partner public key. 
* @param UserPrivKey_ptr [in] - A pointer to a user private key.
* @param SharedSecretValue_ptr [out] - A pointer to an output buffer that will 
*                          contain the shared secret value.
* @param SharedSecrValSize_ptr [in\out] - A pointer to the size of user passed 
*                          buffer (in) and actual output size of 
*                          calculated shared secret value.
*
* Outputs:
* @returns \b CE2Error_t 
*  - CE2_OK - on success
*  - Otherwise - error code:
*
* \brief \b 
* Description:
*  Creates the shared secret value accordingly to the IEEE 1363-2000 
*  standard.
*
*  \b 
* Algorithm:
*  -# Verify input parameters for validity;
*  -# Call low level function LLF_ECDH_SVDP_DH 
*     for creation of shared secret with using LibTomCrypt.
***************************************************************/
CE2Error_t LLF_ECDH_SVDP_DH( 
    CE2_ECPKI_UserPublKey_t *BuildedPartnerPublKey_ptr, /*in*/
    CE2_ECPKI_UserPrivKey_t *UserPrivKey_ptr,           /*in*/							                
    DxUint8_t		 *SharedSecretValue_ptr,     /*out*/
    DxUint32_t               *SharedSecrValSize_ptr    /*in/out*/);

#ifdef __cplusplus
}
#endif

#endif /* LLF_ECPKI_DH_H */
